package cn.com.duiba.cloud.manage.service.api.remoteservice.mallfurnish;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallfurnish.MallAppPhotoDto;
import cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish.MallAppPhotoSearchParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 图片表
 * @author kjj mybatis generator 
 * @date 2022-06-15
 */
@AdvancedFeignClient
public interface RemoteMallAppPhotoService{
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 图片集合
     */
    List<MallAppPhotoDto> selectList(MallAppPhotoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(MallAppPhotoSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 图片
     */
    MallAppPhotoDto selectById(Long id);

    /**
     * 新增
     * @param entity 图片
     * @return 执行结果
     */
    int insert(MallAppPhotoDto entity);

    /**
     * 更新
     * @param entity 图片
     * @return 执行结果
     */
    int update(MallAppPhotoDto entity);

    /**
     * 删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询
     * @param param
     * @return 图片
     */
    PageResponse<MallAppPhotoDto> page(MallAppPhotoSearchParam param);

    /**
     * 批量删除
     * @param ids 主键
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

}