package cn.com.duiba.cloud.manage.service.api.model.dto.app;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/30 14:07
 */
@Getter
@Setter
public class AppDTO implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * appcode
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 创建者
     */
    private Long appCreator;

    /**
     * 应用类型 0-平台应用 1-租户创建应用
     */
    private String appType;

    /**
     * 0 下架 1 可用
     */
    private Integer appStatus;

    /**
     * 应用描述
     */
    private String appDesc;

    /**
     * 应用版本
     */
    private String appVersion;

    /**
     * 是否定向可见 0-不设置 1-定向可见，并设置APP与租户关系表
     */
    private Integer orientation;

    /**
     * 应用访问的URL
     */
    private String url;

    /**
     * 域名地址
     */
    private String domainUrl;

    /**
     * logo url
     */
    private String logoUrl;

    /**
     * 颜色
     */
    private String color;
}
