package cn.com.duiba.cloud.manage.service.api.model.enums.operation.assistant.shortlink;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 短链任务状态枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 21:09
 * @since 0.0.7
 **/
@Getter
@AllArgsConstructor
public enum ShortLinkTaskEnum implements IEnum<Integer> {
    /**
     * 已完成
     */
    COMPLETE(1, "已完成"),

    /**
     * 转换中
     */
    CONVERSION(2, "转换中"),

    /**
     * 生成中
     */
    GENERATE(3, "生成中"),

    /**
     * 已生成
     */
    GENERATED(4, "已生成"),
    ;

    /**
     * 状态id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;
}
