package cn.com.duiba.cloud.manage.service.api.model.param.autologin;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据加密参数
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/22 10:34 上午
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class EncryptDataParam implements Serializable {
    private static final long serialVersionUID = -5716896610837919027L;
    /**
     * 需要加密的内容
     */
    @NotNull(message = "需要加密的内容不能为空")
    private String data;

    /**
     * 加密的时间戳
     */
    @NotNull(message = "加密的时间戳不能为空")
    private Long timestamp;
}
