package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 09:45
 */
@Getter
@Setter
public class RemoteStoreEditParam extends BaseParam {

    /**
     * 门店id
     */
    @Max(value = Long.MAX_VALUE, message = "门店id长度超过最大限制")
    @NotNull(message = "门店id不能为空")
    private Long id;

    /**
     * 门店名称
     */
    @NotBlank(message = "门店名称不能为空")
    private String name;

    /**
     * 门店地区
     */
    @NotBlank(message = "门店地区不能为空")
    private List<String> addressCode;

    /**
     * 详细地址
     */
    @NotBlank(message = "详细地址不能为空")
    private String address;
}
