package cn.com.duiba.cloud.manage.service.api.remoteservice.autologin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.param.autologin.DecryptDataParam;
import cn.com.duiba.cloud.manage.service.api.model.param.autologin.EncryptDataParam;

/**
 * 免登服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/22 10:32 上午
 **/
@AdvancedFeignClient
public interface RemoteAutoLoginService {

    /**
     * 获取加密key
     *
     * @param timestamp
     * @return
     * @throws BizException
     */
    String getEncryptKey(Long timestamp) throws BizException;

    /**
     * cookie数据解密
     *
     * @param param
     * @return
     */
    String cookieDataDecrypt(DecryptDataParam param) throws BizException;

    /**
     * cookie数据加密
     *
     * @param param
     * @return
     * @throws BizException
     */
    String cookeDataEncrypt(EncryptDataParam param) throws BizException;
}
