package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 页面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/13
 */
@Data
public class MallAppPageDetailDTO implements Serializable {

    private static final long serialVersionUID = -1452695964773729089L;

    private Long id;

    /**
     * 页面名称
     */
    private String pageTitle;

    /**
     * 页面状态 0-未发布 1-已发布
     */
    private Integer pageStatus;

    /**
     * 是否存在定时发布 0-不存在 1-存在
     */
    private Integer hasTimingPublish;

    /**
     * 定时任务id
     */
    private Long taskId;

    /**
     * 发布时间
     */
    private Date publishTime;

    /**
     * 页面类型 0-普通页面 1-首页
     */
    private Integer isFrontPage;

    /**
     * 页面内容
     */
    private String pageContent;

    /**
     * 租户应用id
     */
    private Long appId;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改人
     */
    private Long modifiedBy;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
