package cn.com.duiba.cloud.manage.service.api.model.dto.store;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/18 11:40
 */
@Getter
@Setter
@ToString
public class StoreDiscountDTO implements Serializable {

    /**
     * 门店优惠id
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 唤端类型 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.CallTypeEnum}
     */
    private Integer callType;

    /**
     * 优惠类型 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.DiscountTypeEnum}
     */
    private Integer discountType;

    /**
     * 商品来源 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.GoodsSourceEnum}
     */
    private Integer source;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 单位类型
     */
    private String unitType;

    /**
     * 商品价格
     */
    private Double goodsPrice;

    /**
     * 商品链接
     */
    private String goodsLink;

    /**
     * 供应商应用id
     */
    private Long supplierAppId;

    /**
     * 门店id，英文逗号隔开
     */
    private String storeId;

    /**
     * 状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum}
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
