package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.mallapp.VipGradeEnum;
import cn.com.duiba.wolf.entity.Pair;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

/**
 * @author zhengjianhao
 * @date 2022/6/23
 * @description
 */
public class VipLevelUtil {

	/**
	 * 根据成长值获取匹配的等级，通用方法
	 */
	public static MallAppVipGradeDTO matchLevelConfByGrowthValue(Long growthValue, List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
		if (CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)) {
			return null;
		}
		MallAppVipGradeDTO baseLevelConf = getBaseLevelConf(mallAppVipLevelConfDtoList);
		if (null == growthValue || growthValue <= 0) {
			return baseLevelConf;
		}
		MallAppVipGradeDTO matchedLevelConf = null;
		// 等级配置根据等级权重，从高到低排序
		mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade).reversed());
		for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
			if (growthValue >= levelConfDTO.getUpgradeGrowthValue()) {
				matchedLevelConf = levelConfDTO;
				break;
			}
		}
		if (null == matchedLevelConf) {
			matchedLevelConf = baseLevelConf;
		}
		return matchedLevelConf;
	}

	/**
	 * 获取同等级、较高等级配置：oldLevelCurrentConf、higherLevelConf 均有可能为空
	 */
	public static Pair<MallAppVipGradeDTO, MallAppVipGradeDTO> getCurrentOldAndHigherConf(Integer grade,
			List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
		if(CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)){
			return Pair.from(null, null);
		}
		// 获取用户等级的旧的配置
		MallAppVipGradeDTO oldLevelCurrentConf = null;
		// 较高等级的配置
		MallAppVipGradeDTO higherLevelConf = null;
		// 等级配置根据等级权重，从低到高排序
		mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade));
		for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
			if (grade.equals(levelConfDTO.getGrade())) {
				oldLevelCurrentConf = levelConfDTO;
			}
			if (grade < levelConfDTO.getGrade()) {
				higherLevelConf = levelConfDTO;
				break;
			}
		}
		return Pair.from(oldLevelCurrentConf, higherLevelConf);
	}

	/**
	 * 根据等级获取低一级的配置
	 */
	public static MallAppVipGradeDTO getLowerLevelConf(Integer grade, List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList) {
		if(CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)){
			return null;
		}
		MallAppVipGradeDTO matchedLevelConf = null;
		// 等级配置根据等级权重，从高到低排序
		mallAppVipLevelConfDtoList.sort(Comparator.comparing(MallAppVipGradeDTO::getGrade).reversed());
		for (MallAppVipGradeDTO levelConfDTO : mallAppVipLevelConfDtoList) {
			if (grade > levelConfDTO.getGrade()) {
				matchedLevelConf = levelConfDTO;
				break;
			}
		}
		if (null == matchedLevelConf) {
			matchedLevelConf = getBaseLevelConf(mallAppVipLevelConfDtoList);
		}
		return matchedLevelConf;
	}

	/**
	 * 获取基础等级配置
	 */
	public static MallAppVipGradeDTO getBaseLevelConf(List<MallAppVipGradeDTO> mallAppVipLevelConfDtoList){
		if(CollectionUtils.isEmpty(mallAppVipLevelConfDtoList)){
			return null;
		}
		return mallAppVipLevelConfDtoList.stream()
		                                 .filter(x -> Objects.equals(x.getGrade(), VipGradeEnum.GRADE_0.getGrade()))
		                                 .findFirst().orElse(null);
	}
}
