package cn.com.duiba.cloud.manage.service.api.model.enums.dept;

import java.util.Objects;

/**
 * @author linzhou
 * @ClassName StaffStateEnum.java
 * @createTime 2021年11月08日 16:39:00
 * @Description
 */
public enum DeptStaffIdentityEnum {

    ADMIN(0,"主管"),
    STAFF(1,"普通员工"),
    ;
    private Integer code;

    private String desc;

    DeptStaffIdentityEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static DeptStaffIdentityEnum getEnum(Integer code){
        for (DeptStaffIdentityEnum value : DeptStaffIdentityEnum.values()) {
            if (Objects.equals(value.code,code)){
                return value;
            }
        }
        return null;
    }

    public static String getDEscByCode(Integer code){
        for (DeptStaffIdentityEnum value : DeptStaffIdentityEnum.values()) {
            if (Objects.equals(value.code,code)){
                return value.desc;
            }
        }
        return "";
    }
}
