package cn.com.duiba.cloud.manage.service.api.remoteservice.exportrecord;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.exportrecord.ExportDataResultDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.RemoteIdParam;
import cn.com.duiba.cloud.manage.service.api.model.param.exportrecord.RemoteExportRecordRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.exportrecord.RemoteRefreshProgressRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.exportrecord.RemoteUpdateStateRequest;

/**
 * @author linzhou
 * @ClassName ReomteDeptService.java
 * @createTime 2021年11月08日 13:52:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteExportDataService {

    /**
     * 导出
     *
     * @param request
     * @return
     * @throws BizException
     */
    ExportDataResultDTO exportData(RemoteExportRecordRequest request) throws BizException;

    /**
     * 获取导出进度
     *
     * @param idParam
     * @return
     * @throws BizException
     */
    ExportDataResultDTO getExportRecord(RemoteIdParam idParam) throws BizException;

    /**
     * 创建导入记录
     *
     * @param request
     * @return
     */
    Long createExportRecord(RemoteExportRecordRequest request);

    /**
     * 刷新进度
     *
     * @param request
     */
    void refreshProgress(RemoteRefreshProgressRequest request);

    /**
     * 修改导出状态
     *
     * @param request
     */
    void updateState(RemoteUpdateStateRequest request);
}
