package cn.com.duiba.cloud.manage.service.api.model.param.app;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/12/27 11:25
 */
@Getter
@Setter
public class RemoteSubscribedAppParam implements Serializable {

    private static final long serialVersionUID = 2545732644927229688L;

    /**
     * 租户id
     */
    @NotNull(message = "租户id不能为空")
    private Long tenantId;

    /**
     * 应用类型
     */
    private String appType;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 是否返回默认应用, 默认不返回
     */
    private Boolean needDefault;
}
