package cn.com.duiba.cloud.manage.service.api.model.enums;

import java.util.Arrays;

/**
 * @program: duiba-manage-service
 * @description: 服务时长枚举
 * @author: 郭云龙
 * @create: 2022-03-24 15:32
 **/
public enum ServiceTimeEnum {

    /**
     *
     */
    ONE_YEAR(1L, "1年", UnitEnum.Y.name(), 1),
    SEVEN_DAYS(7L, "7天", UnitEnum.D.name(), 7),
    CUSTOMIZE(99L, "自定义"),
    ;


    enum UnitEnum {
        Y, M, D;
    }

    /**
     * id
     */
    private Long serviceTimeId;

    /**
     * 应用类型
     */
    private String serviceTimeName;

    /**
     * 单位 Y-年 M-月 D-日
     */
    private String unit;

    /**
     * 时长
     */
    private Integer duration;

    ServiceTimeEnum(Long serviceTimeId, String serviceTimeName, String unit, Integer duration) {

        this.serviceTimeId = serviceTimeId;
        this.serviceTimeName = serviceTimeName;
        this.unit = unit;
        this.duration = duration;
    }

    ServiceTimeEnum(Long serviceTimeId, String serviceTimeName) {
        this.serviceTimeId = serviceTimeId;
        this.serviceTimeName = serviceTimeName;
    }

    public Long getServiceTimeId() {
        return serviceTimeId;
    }

    public String getServiceTimeName() {
        return serviceTimeName;
    }

    public String getUnit() {
        return unit;
    }

    public Integer getDuration() {
        return duration;
    }


    public static String getNameById(Long id){
        return Arrays.stream(ServiceTimeEnum.values())
                .filter(o -> id.equals(o.getServiceTimeId()))
                .findFirst().orElse(ServiceTimeEnum.CUSTOMIZE)
                .getServiceTimeName();
    }
}
