package cn.com.duiba.cloud.manage.service.api.model.dto.rights;

import cn.com.duiba.cloud.manage.service.api.model.enums.StateEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/3/28 18:12
 */
@Getter
@Setter
@ToString
public class TenantSubPkgDTO implements Serializable {

    /**
     * 开通记录ID
     */
    private Long tenantSubPkgId;

    /**
     * 订阅应用ID
     */
    private Long tenantAppId;

    /**
     * 订阅应用名称
     */
    private String tenantAppName;

    /**
     * 应用类型
     */
    private String appTypeName;

    /**
     * 服务类型
     */
    private String serviceTypeName;

    /**
     * 套餐/售卖包ID
     */
    private String rightsPkgId;

    /**
     * 套餐/售卖包名称
     */
    private String rightsPkgName;

    /**
     * 服务开始时间
     */
    private Date serviceTimeStart;

    /**
     * 服务结束
     */
    private Date serviceTimeEnd;

    /**
     * 服务开通状态 {@link StateEnum}
     */
    private String openRecordStatusName;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 操作时间
     */
    private Date operateTime;
}
