package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.cloud.manage.service.api.utils.Code;

/**
 * @program: duiba-manage-service
 * @description: 开通记录状态枚举
 * @author: 郭云龙
 * @create: 2022-03-24 15:46
 **/
public enum OpenRecordStatusEnum {

    /**
     *
     */
    NORMAL(1L,"正常"),
    EXPIRED(0L,"已过期"),
    ;

    /**
     * 状态ID
     */
    @Code
    private Long openRecordStatusId;

    /**
     * 状态名称
     */
    private String openRecordStatusName;

    OpenRecordStatusEnum(Long openRecordStatusId, String openRecordStatusName) {
        this.openRecordStatusId = openRecordStatusId;
        this.openRecordStatusName = openRecordStatusName;
    }

    public Long getOpenRecordStatusId() {
        return openRecordStatusId;
    }

    public String getOpenRecordStatusName() {
        return openRecordStatusName;
    }
}
