package cn.com.duiba.cloud.manage.service.api.remoteservice.rights;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.RightsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rightsPkg.RightsPkgDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.rightsPkg.RemoteRightsPkgAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rightsPkg.RemoteRightsPkgQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rightsPkg.RemoteRightsPkgUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rightsPkg.RemoteStatusOperateParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/18 18:09
 */
@AdvancedFeignClient
public interface RemoteRightsPkgService {

    /**
     * 权益包分页列表
     * @param param 查询参数
     * @return
     */
    PageResponse<RightsPkgDTO> rightsPkgList(RemoteRightsPkgQueryParam param) throws BizException;


    /**
     * 按照rightsPkgId获取详情
     * @param rightsPkgId
     * @return
     * @throws BizException
     */
    RightsPkgDTO selectDetail(Long rightsPkgId) throws BizException;


    /**
     * 权益包状态变更
     * @param param
     * @return
     */
    Integer rightsPkgStatusUpdate(RemoteStatusOperateParam param) throws BizException;

    /**
     * 权益包新增
     * @param param
     * @return
     */
    Integer rightsPkgAdd(RemoteRightsPkgAddParam param) throws BizException;


    /**
     * 权益包修改
     * @param param
     * @return
     */
    Integer rightsPkgUpdate(RemoteRightsPkgUpdateParam param) throws BizException;

    /**
     * 获取权益包选中的权益集合
     * @param rightsPkgId
     * @return
     */
    List<RightsDTO> rightsSelectedList(Long rightsPkgId) throws BizException;


    /**
     * 按照服务类型ID查询
     * @param serviceTypeId
     * @return
     * @throws BizException
     */
    List<RightsPkgDTO> rightsPkgSelectList(Long serviceTypeId) throws BizException;

//    /**
//     * 权益包售卖包查询(分页)
//     *
//     * @param param 查询参数
//     * @return PageResponse<RightsListDTO>
//     */
//    PageResponse<RightsListDTO> page(RemoteRightsPkgListParam param) throws BizException;


//    /**
//     * 添加权益包
//     *
//     * @param param 权益包属性
//     * @return 权益包版本id
//     */
//    Long addRightsPackage(RemoteSaveRightsPackageParam param);
//
//    /**
//     * 添加售卖包
//     *
//     * @param param 售卖包属性
//     * @return 售卖包id
//     */
//    Long addRightsSell(RemoteSaveRightsSellParam param);
//
//    /**
//     * 删除权益包或者售卖包
//     * 如果当前版本或售卖包有租户正在使用,则无法删除
//     *
//     * @param param 要删除的权益包或者售卖包id
//     * @return JsonResult<Long>
//     */
//    Long delete(RemoteDeleteRightsPackageParam param);
//
//    /**
//     * 修改权益包
//     * 如果当前版有租户正在使用,则无法修改
//     *
//     * @param param 权益包属性
//     * @return 权益包版本id
//     */
//    Long updateRightsPackage(RemoteSaveRightsPackageParam param);
//
//    /**
//     * 修改售卖包
//     * 如果当前售卖包有租户正在使用,则无法修改
//     *
//     * @param param 售卖包属性
//     * @return 售卖包id
//     */
//    Long updateRightsSell(RemoteSaveRightsSellParam param);
//
//    /**
//     * 权益包详情
//     *
//     * @param param 权益包id
//     * @return 权益包版本详情
//     */
//    RightsPackageDetailDTO rightsPackageDetail(RemoteRightsPackageParam param);
//
//    /**
//     * 售卖包详情
//     *
//     * @param param 售卖包id
//     * @return 售卖包详情
//     */
//    SellPkgDetailDTO rightsSellDetail(RemoteRightsSellParam param);
//
//    /**
//     * 给权益包或者售卖包添加企业
//     *
//     * @param param 售卖包属性
//     * @return Object
//     */
//    Object addTenantToRights(RemoteAddTenantToRightsParam param);
}
