package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 09:45
 */
@Getter
@Setter
public class RemoteStoreAddParam extends BaseParam {

    /**
     * 门店名称
     */
    @NotBlank(message = "门店名称不能为空")
    private String name;

    /**
     * 门店地区
     */
    @NotBlank(message = "门店地区不能为空")
    private List<String> addressCode;

    /**
     * 详细地址
     */
    @NotBlank(message = "详细地址不能为空")
    private String address;
}
