package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppBaseConfDTO;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 2022/3/29
 * @description 商城应用-基础配置
 */
@AdvancedFeignClient
public interface RemoteMallAppBaseConfService {

	/**
	 * 查询应用配置
	 */
	MallAppBaseConfDTO getAppConf(Long appId);

	/**
	 * 批量查询应用配置
	 * @param appIdList 应用id list
	 * @return List<MallAppBaseConfDTO>
	 */
	List<MallAppBaseConfDTO> getAppConfList(List<Long> appIdList);

	/**
	 * 保存积分单位基础配置
	 */
	void updateCreditsBaseConf(MallAppBaseConfDTO mallAppBaseConfDTO) throws BizException;

	/**
	 * 保存接口配置
	 */
	void updateInterfaceConf(MallAppBaseConfDTO mallAppBaseConfDTO) throws BizException;

	/**
	 * 保存登录配置
	 */
	void updateLoginConf(MallAppBaseConfDTO mallAppBaseConfDTO) throws BizException;

	/**
	 * 保存会员运营基础配置
	 */
	void updateVipOperateConf(MallAppBaseConfDTO mallAppBaseConfDTO) throws BizException;

	/**
	 * 覆盖所有基础配置
	 */
	void saveAllConf(MallAppBaseConfDTO mallAppBaseConfDTO) throws BizException;
}
