package cn.com.duiba.cloud.manage.service.api.remoteservice.tenant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.RsSupplierDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.SupplierInfoDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteSupplierAppParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteSupplierInfoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteSupplierIdListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RemoteSupplierListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RsTenantRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RsTenantUpdateCheckGoodsRequest;
import cn.com.duiba.cloud.manage.service.api.model.param.tenant.RsTenantUpdateStatusRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/5 10:17
 */
@AdvancedFeignClient
public interface RemoteRsSupplierService {

    /**
     * 添加租户关系
     *
     * @param request
     * @return
     * @throws BizException
     */
    Long addRsTenant(RsTenantRequest request) throws BizException;

    /**
     * 修改租户关系状态
     *
     * @param request
     * @return
     * @throws BizException
     */
    Boolean updateStatus(RsTenantUpdateStatusRequest request) throws BizException;


    /**
     * 更新审核商品的接口
     *
     * @param request
     * @return
     * @throws BizException
     */
    Boolean updateCheckGoods(RsTenantUpdateCheckGoodsRequest request) throws BizException;

    /**
     * 查询供货关系
     *
     * @param request
     * @return
     */
    List<RsSupplierDTO> getBySupplierApp(RemoteSupplierAppParam request);

    /**
     * 获取供应商列表
     *
     * @param request
     * @return
     */
    PageResponse<RsSupplierDTO> getSupplierList(RemoteSupplierListParam request);

    /**
     * 获取供货关系
     *
     * @param remoteSupplierInfoParam
     * @return
     */
    SupplierInfoDTO supplierInfo(RemoteSupplierInfoParam remoteSupplierInfoParam) throws BizException;


    /**
     * 根据供应商名称模糊匹配获取供应商列表
     *
     * @param request
     * @return
     */
    PageResponse<Long> getSupplierIdList(RemoteSupplierIdListParam request);
}