package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 页面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/13
 */
@Data
public class MallAppPageDTO implements Serializable {

    /** 大字段 */
    public static final String BIG_ATTR_PAGE_CONTENT = "pageContent";

    private static final long serialVersionUID = -8900701173036927626L;
    /**
     * 页面id
     */
    private Long id;

    /**
     * 页面名称
     */
    private String pageTitle;

    /**
     * 页面状态 0-未发布 1-已发布 2-定时发布
     */
    private Integer queryPageStatus;

    /**
     * 是否是首页 false/不是 true/首页
     */
    private Boolean isFrontPage;

    /**
     * 页面内容
     */
    private String pageContent;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 任务id
     */
    private Long taskId;

    /**
     * 发布时间
     */
    private Date publishTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
