package cn.com.duiba.cloud.manage.service.api.remoteservice.rights;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AllRightsDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AppRightsDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.AppRightsQueryDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.rights.RightsDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsDeleteParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsRenameParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsSaveParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsSortUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppRightsUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsByLevelOneAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsByLevelOneAndTwoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsByLevelTwoAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteAppTypeRightsUpdateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteNotOrderedVisibleSwitchOperateParam;
import cn.com.duiba.cloud.manage.service.api.model.param.rights.RemoteUpgradeAppRightsPkgParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 应用权益服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/11/22
 */
@AdvancedFeignClient
public interface RemoteAppTypeRightsService {

    /**
     * 升级应用权益包 - 目前只升级供应商的
     * @param param
     * @throws BizException
     */
    void upgradeAppRightsPkg(RemoteUpgradeAppRightsPkgParam param) throws BizException;

    /**
     * 查询应用权益
     * @param queryParam
     * @return
     */
    public AppRightsQueryDTO appRightsQuery(RemoteAppRightsQueryParam queryParam) throws BizException;

    /**
     * 保存权益
     * @param saveParam
     * @throws BizException
     */
    public void appRightsSave(RemoteAppRightsSaveParam saveParam) throws BizException;

    /**
     * 更新权益
     * @param updateParam
     * @throws BizException
     */
    public void appRightsUpdate(RemoteAppRightsUpdateParam updateParam) throws BizException;

    /**
     * 删除应用权益
     * @param deleteParam
     * @throws BizException
     */
    public void appRightsDelete(RemoteAppRightsDeleteParam deleteParam) throws BizException;

    /**
     * 权益重命名
     * @param renameParam
     * @throws BizException
     */
    public void appRightsRename(RemoteAppRightsRenameParam renameParam) throws BizException;

    /**
     * 应用权益详情
     * @param detailParam
     * @return
     * @throws BizException
     */
    public AppRightsDetailDTO appRightsDetail(RemoteAppRightsDetailParam detailParam) throws BizException;

    /**
     * 修改权益排序
     * @param updateParam
     * @throws BizException
     */
    public void appRightsSortUpdate(RemoteAppRightsSortUpdateParam updateParam) throws BizException;

    /**
     * 查询所有权益
     * @return
     * @throws BizException
     */
    public AllRightsDTO allRights() throws BizException;

    /**
     * 获取一级权益目录
     * @return
     */
    List<RightsDTO> rightsListByLevenOne(Long appTypeId) throws BizException;

    /**
     * 根据一级权益ID获取剩余权益列表
     * 权益只有三级
     * @return
     */
    List<RightsDTO> rightsTree(RemoteAppTypeRightsQueryParam param) throws BizException;


    /**
     * 根据应用类型获取一级二级权益数据
     * @param param
     * @return
     * @throws BizException
     */
    List<RightsDTO> rightsListByLevenOneAndTwo(RemoteAppTypeRightsByLevelOneAndTwoParam param) throws BizException;

    /**
     * 分页获取三级权益
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<RightsDTO> rightsListPage(RemoteAppTypeRightsPageQueryParam param) throws BizException;
    /**
     * 添加一级权益
     * @param param
     * @return
     * @throws BizException
     */
    Integer rightsAddByLevenOne(RemoteAppTypeRightsByLevelOneAddParam param) throws BizException;

    /**
     * 添加二级权益
     * @param param
     *eturn
     * @throws BizException
     */
    Integer rightsAddByLevenTwo(RemoteAppTypeRightsByLevelTwoAddParam param) throws BizException;

    /**
     * 未订购可见操作
     * @param param
     * @return
     * @throws BizException
     */
    Integer notOrderedVisibleSwitchOperate(RemoteNotOrderedVisibleSwitchOperateParam param) throws BizException;

    /**
     * 添加权益功能-三级权益
     * @param param
     * @return
     * @throws BizException
     */
    Integer rightsAdd(RemoteAppTypeRightsAddParam param) throws BizException;

    /**
     * 修改权益功能-三级权益
     * @param param
     * @return
     * @throws BizException
     */
    Integer rightsUpdate(RemoteAppTypeRightsUpdateParam param) throws BizException;
}
