package cn.com.duiba.cloud.manage.service.api.model.dto.store;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 10:54
 */
@Getter
@Setter
@ToString
public class StoreDiscountPageDTO implements Serializable {

    /**
     * 门店优惠id
     */
    private Long id;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品来源
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.store.GoodsSourceEnum
     */
    private Integer source;

    /**
     * 应用ID
     */
    private Long tenantAppId;

    /**
     * 应用名称
     */
    private String tenantAppName;

    /**
     * 投放门店数量
     */
    private Long storeNum;

    /**
     * 供应商应用ID
     */
    private Long supplierAppId;

    /**
     * 供应商应用名称
     */
    private String supplierAppName;

    /**
     * 上架状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.ShelfStateEnum}
     */
    private Integer state;
}
