package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description redis key
 * @date 2021/11/8 11:20
 */
public enum RedisKeyEnum {

    /* 权益相关 */
    TENANT_RIGHTS_CACHE("租户权益缓存", "DUIBA_MANAGE_SERVICE:TENANT_RIGHTS:{}"),

    /**
     * 租户相关
     */
    FIRST_LOGIN("首次登录", "DUIBA_MANAGE_SERVICE:FIRST_LOGIN"),
    CAPTCHA("图片验证码", "DUIBA_MANAGE_SERVICE:CAPTCHA"),
    LAST_LOGIN("上次登录", "DUIBA_MANAGE_SERVICE:LAST_LOGIN"),
    TENANT_STAFF_REL("租户内员工关系", "DUIBA_MANAGE_SERVICE:TENANT_STAFF_REL:{}_{}"),

    /* 角色相关 */

    UNIQUE_TENANT_APP_ROLE_NAME("租户下角色名称唯一", "DUIBA_MANAGE_SERVICE:TB_ROLE:{}_{}_{}"),
    UNIQUE_TENANT_NAME("租户名称唯一", "DUIBA_MANAGE_SERVICE:TB_TENANT:{}"),
    UNIQUE_DEPT_NAME("部门名称唯一", "DUIBA_MANAGE_SERVICE:TB_DEPT:{}"),
    UNIQUE_RS_TENANT_ADD("添加关联租户锁", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT:{tenantId}_{tenantIdTo}"),
    UNIQUE_RS_TENANT_UPDATE_STATE("修改关联租户状态锁", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT:{tenantId}_{id}"),

    /* 应用相关 */
    UNIQUE_APP_CREATE("应用创建唯一", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT_APP:{}_{}",
            "租户id tenantId", "应用id appId"),
    APP_COOKIE_INFO("租户应用cookie信息", "DUIBA_MANAGE_SERVICE:COOKIE_INFO:{}_{}", "用户id", "租户id"),

    /**
     * redission 锁（ps: 不要用 冒号 间隔符 ）
     */
    LOCK_01("开通/编辑/续费套餐、售卖包加锁", "DUIBA_MNG_SERVICE_OPEN_RECORD_{}_{}", "租户应用id", "套餐版本/售卖包id"),

    /**
     * 门店相关
     */
    LOCK_STORE_ADD("新增门店加锁", "DUIBA_MNG_SERVICE_STORE_ADD_{}_{}", "应用id", "门店名称"),

    HASH_STORE_BRAND_LOGO("门店品牌logo", "DUIBA_MNG_SERVICE_STORE_LOGO", "应用id"),

    /**
     * 门店优惠相关
     */
    LOCK_STORE_DISCOUNT_ADD("新增门店优惠加锁", "DUIBA_MNG_SERVICE_STORE_DISCOUNT_ADD_{}_{}", "应用id", "商品名称"),


    /* 用户登陆令牌 */
    USER_LOGIN_TOKEN("用户登陆令牌", "SSO_TICKET:{}", "令牌号"),

    /**
     * 租户积分商城应用会员等级配置初始化
     */
    LOCK_INIT_VIP_LEVEL("积分商城应用会员等级配置初始化锁", "DUIBA_MNG_SERVICE_INIT_VIP_LEVEL_{}", "积分商城应用id"),


    /* 页面相关 */
    PAGE_TIMING_PUBLISH("页面定时发布", "DUIBA_PAGE_TIMING_PUBLISH:{}", "应用id"),
    PAGE_SET_INDEX("页面设置首页", "DUIBA_PAGE_SET_INDEX:{}", "应用id"),
    PAGE_DETAIL("页面详情", "DUIBA_PAGE_DETAIL:{}", "页面id"),
    ;

    private final String template;
    private final String desc;
    private final String[] argsDesc;

    RedisKeyEnum(String desc, String template, String...argsDesc) {
        this.template = template;
        this.desc = desc;
        this.argsDesc = argsDesc;
    }

    /**
     * replace by {@link RedisKeyEnum#getKey}
     */
    @Deprecated
    public static String getRedisKey(RedisKeyEnum keyTemplate, Object... args) {
        return StrUtil.format(keyTemplate.template, args);
    }

    /**
     * 拼接key
     */
    public static String getKey(RedisKeyEnum keyTemplate, Object... args) throws BizException {
        // 校验参数数量是否正确
        int count = StrUtil.count(keyTemplate.template, "{}");
        Conditions.expectTrue(ObjectUtil.equals(count, args.length), "参数数量缺失");
        return StrUtil.format(keyTemplate.template, args);
    }

    public String getTemplate() {
        return template;
    }
}
