/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.config;

import cn.com.duiba.cloud.manage.service.autologin.sdk.config.OpenApiProperties;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.OpenApiInterceptor;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.OpenApiInterceptorHandlerManager;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.LoginInterceptor;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Order(value=-1)
@EnableConfigurationProperties(value={OpenApiProperties.class})
public class OpenApiSdkConfiguration
implements WebMvcConfigurer {
    @Resource
    private OpenApiProperties properties;

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.properties.getPathPatterns();
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String excludePathPatterns = this.properties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        OpenApiInterceptor openApiInterceptor = this.openApiInterceptor();
        registry.addInterceptor((HandlerInterceptor)openApiInterceptor).addPathPatterns(paths).excludePathPatterns(excludePath);
    }

    @Bean
    @ConditionalOnProperty(prefix="duiba.openapi.interceptor", value={"login"}, havingValue="true", matchIfMissing=true)
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiInterceptorHandlerManager openApiInterceptorHandlerManager() {
        return new OpenApiInterceptorHandlerManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiInterceptor openApiInterceptor() {
        return new OpenApiInterceptor();
    }
}

