/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class OpenApiRequestTool {
    private static final ThreadLocal<OpenApiRequestTool> LOCAL = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private JSONObject adminInfo;

    private static OpenApiRequestTool get() {
        if (LOCAL.get() == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u672c\u5730\u53d8\u91cf");
        }
        return LOCAL.get();
    }

    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new IllegalArgumentException("RequestTool\u6ce8\u5165request\u4e3a\u7a7a");
        }
        if (response == null) {
            throw new IllegalArgumentException("RequestTool\u6ce8\u5165response\u4e3a\u7a7a");
        }
        OpenApiRequestTool tool = new OpenApiRequestTool();
        tool.request = request;
        tool.response = response;
        tool.adminInfo = new JSONObject();
        LOCAL.set(tool);
    }

    public static void removeRequestInThreadLocal() {
        LOCAL.remove();
    }

    public static Boolean isAsynchronousRequests() {
        HttpServletRequest request = OpenApiRequestTool.getRequest();
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return StringUtils.isNotBlank((String)re) && StringUtils.equals((String)"XMLHttpRequest", (String)re) || StringUtils.isNotBlank((String)accept) && accept.contains("json");
    }

    public static HttpServletResponse getResponse() {
        return OpenApiRequestTool.get().response;
    }

    public static HttpServletRequest getRequest() {
        return OpenApiRequestTool.get().request;
    }

    public static JSONObject getAdminInfo() {
        return OpenApiRequestTool.get().adminInfo;
    }
}

