/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.constant.OpenApiSdkErrorCode;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.OpenApiInterceptorHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.LoginUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class LoginInterceptor
implements OpenApiInterceptorHandler {
    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            CanAccess canAccess = (CanAccess)AnnotationUtils.findAnnotation((Method)method.getMethod(), CanAccess.class);
            if (Objects.nonNull(canAccess)) {
                return Boolean.TRUE;
            }
            ConsumerCookieDTO consumerInfo = AutoLoginUtil.getConsumerInfo();
            if (null == consumerInfo || null == consumerInfo.getCid()) {
                throw new BizException(OpenApiSdkErrorCode.NO_PERMISSION.getMsg()).withCode(OpenApiSdkErrorCode.NO_PERMISSION.getCode());
            }
            LoginUtils.setConsumerInfo(consumerInfo);
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return -1;
    }
}

