package cn.com.duiba.cloud.manage.service.autologin.sdk.verification;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;

/**
 * @program: duiba-manage-service
 * @description: 通用校验
 * @author: 郭云龙
 * @create: 2022-05-30 15:55
 **/
public interface CommonVerification {

//    Boolean


    /**
     * 获取租户订阅应用的详情
     * @param id
     * @return
     * @throws BizException
     */
    TenantAppDTO detail(Long id) throws BizException;

    /**
     * 校验应用过期
     * @param id
     * @return
     * @throws BizException
     */
    Boolean verifyTenantAppOverdue(Long id) throws BizException;


    /**
     * 校验应用限制开关
     * @param id
     * @return
     * @throws BizException
     */
    Boolean verifyTenantAppTradeLimit(Long id) throws BizException;
}
