package cn.com.duiba.cloud.manage.sdk.handler;

import cn.com.duiba.cloud.manage.sdk.annotation.TenantAppOverdueAnnotation;
import cn.com.duiba.cloud.manage.sdk.config.ToCManageServiceConfigProperties;
import cn.com.duiba.cloud.manage.sdk.utils.ToCManageServiceRequestTool;
import cn.com.duiba.cloud.manage.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @program: duiba-manage-service
 * @description:
 * @author: 郭云龙
 * @create: 2022-05-30 15:09
 **/
@EnableConfigurationProperties(ToCManageServiceConfigProperties.class)
@Slf4j
public class TenantAppOverdueHandler implements ToCManageServiceHandler{

    @Resource
    private ToCManageServiceConfigProperties properties;

    @Resource
    private CommonVerification commonVerification;
    @Override
    public Boolean accept(Object handler) throws Exception {

        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;

            TenantAppOverdueAnnotation tenantAppOverdueAnnotation = AnnotationUtils.getAnnotation(method.getMethod(), TenantAppOverdueAnnotation.class);

            //如果注解不存在，直接返回
            if(Objects.isNull(tenantAppOverdueAnnotation)){
                return Boolean.TRUE;
            }

            //获取参数的需继续联调，防止取不到信息
            String tenantAppId = ToCManageServiceRequestTool.getRequest().getParameter(tenantAppOverdueAnnotation.fieldVerity());
            //如果取不到值，通过cookie获取
            if(StringUtils.isBlank(tenantAppId)){
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull(consumerCookieDTO,ErrorCode.TENANT_APP_ID_NOT_NULL);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull(tenantAppId,ErrorCode.TENANT_APP_ID_NOT_NULL);

            Boolean verifyTenantAppOverdue = commonVerification.verifyTenantAppOverdue(Long.parseLong(tenantAppId));
            if (verifyTenantAppOverdue) {
                return Boolean.TRUE;
            } else {
                log.error("tenantApp:{} Overdue:{} ",tenantAppId,verifyTenantAppOverdue);
                //返回CODE码
                ToCManageServiceRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JsonResult result = JsonResult.fail(ErrorCode.TENANT_APP_OVERDUE.getCode(), ErrorCode.TENANT_APP_OVERDUE.getMsg());
                ToCManageServiceRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                //跳转到某个地址
//                ToCManageServiceRequestTool.getResponse().setHeader("Content-Type", "text/html;charset=UTF-8");
//                ToCManageServiceRequestTool.getResponse().sendRedirect(properties.getTenantAppOverdueRedirectUrl());
                return Boolean.FALSE;
            }

        }

        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 10;
    }
}
