package cn.com.duiba.cloud.manage.sdk.config;

import cn.com.duiba.cloud.manage.sdk.handler.TenantAppOverdueHandler;
import cn.com.duiba.cloud.manage.sdk.handler.TenantAppTradeLimitHandler;
import cn.com.duiba.cloud.manage.sdk.interceptor.ToCManageServiceHandlerManager;
import cn.com.duiba.cloud.manage.sdk.interceptor.ToCManageServiceInterceptor;
import cn.com.duiba.cloud.manage.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.sdk.verification.impl.CommonVerificationImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

/**
 * 拦截器配置
 *
 * @author gyl
 * @version 1.0
 * @date 2022/5/24
 */
@Configuration
@EnableConfigurationProperties(ToCManageServiceConfigProperties.class)
public class ToCManageServiceConfiguration implements WebMvcConfigurer {

    @Resource
    private ToCManageServiceConfigProperties properties;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = properties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns, ",");

        String excludePathPatterns = properties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{}
                : StringUtils.split(excludePathPatterns, ",");

        ToCManageServiceInterceptor openApiInterceptor = toCManageServiceInterceptor();
        registry.addInterceptor(openApiInterceptor)
                .addPathPatterns(paths)
                .excludePathPatterns(excludePath);
    }

    @Bean
    @ConditionalOnMissingBean
    public ToCManageServiceHandlerManager toCManageServiceHandlerManager() {
        return new ToCManageServiceHandlerManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public ToCManageServiceInterceptor toCManageServiceInterceptor() {
        return new ToCManageServiceInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppOverdueHandler tenantAppOverdueHandler() {
        return new TenantAppOverdueHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppTradeLimitHandler tenantAppTradeLimitHandler() {
        return new TenantAppTradeLimitHandler();
    }


    @Bean
    @ConditionalOnMissingBean
    public CommonVerification permissionVerificationRemote() {
        return new CommonVerificationImpl();
    }
}
