/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.sdk.config;

import cn.com.duiba.cloud.manage.sdk.config.ToCManageServiceConfigProperties;
import cn.com.duiba.cloud.manage.sdk.handler.TenantAppOverdueHandler;
import cn.com.duiba.cloud.manage.sdk.handler.TenantAppTradeLimitHandler;
import cn.com.duiba.cloud.manage.sdk.interceptor.ToCManageServiceHandlerManager;
import cn.com.duiba.cloud.manage.sdk.interceptor.ToCManageServiceInterceptor;
import cn.com.duiba.cloud.manage.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.sdk.verification.impl.CommonVerificationImpl;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Order(value=0)
@EnableConfigurationProperties(value={ToCManageServiceConfigProperties.class})
public class ToCManageServiceConfiguration
implements WebMvcConfigurer {
    @Resource
    private ToCManageServiceConfigProperties properties;

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.properties.getPathPatterns();
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String excludePathPatterns = this.properties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        ToCManageServiceInterceptor openApiInterceptor = this.toCManageServiceInterceptor();
        registry.addInterceptor((HandlerInterceptor)openApiInterceptor).addPathPatterns(paths).excludePathPatterns(excludePath);
    }

    @Bean
    @ConditionalOnMissingBean
    public ToCManageServiceHandlerManager toCManageServiceHandlerManager() {
        return new ToCManageServiceHandlerManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public ToCManageServiceInterceptor toCManageServiceInterceptor() {
        return new ToCManageServiceInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppOverdueHandler tenantAppOverdueHandler() {
        return new TenantAppOverdueHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppTradeLimitHandler tenantAppTradeLimitHandler() {
        return new TenantAppTradeLimitHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public CommonVerification permissionVerificationRemote() {
        return new CommonVerificationImpl();
    }
}

