/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.sdk.interceptor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.sdk.interceptor.ToCManageServiceHandlerManager;
import cn.com.duiba.cloud.manage.sdk.utils.ToCManageServiceRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ToCManageServiceInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ToCManageServiceInterceptor.class);
    @Resource
    private ToCManageServiceHandlerManager manager;
    private static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            return Boolean.TRUE;
        }
        ToCManageServiceRequestTool.setRequestInThreadLocal(request, response);
        if (this.isSpecialRequest(request, handler)) {
            return Boolean.TRUE;
        }
        try {
            if (!this.manager.doHandler(handler).booleanValue()) {
                return Boolean.FALSE;
            }
        }
        catch (BizException e) {
            log.warn("openapi interceptor BizException, errorCode:{}, errorMsg:{}", (Object)e.getCode(), (Object)e.getMessage());
            return Boolean.FALSE;
        }
        catch (Exception e) {
            log.error("openapi interceptor unknown Exception, error:", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) throws Exception {
        ToCManageServiceRequestTool.removeRequestInThreadLocal();
    }

    private void interceptResponse(HttpServletResponse response, String code, String message) throws IOException {
        if (ToCManageServiceRequestTool.isAsynchronousRequests().booleanValue()) {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.getWriter().write(JSONObject.toJSONString((Object)JsonResult.fail((String)code, (String)message)));
        } else {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write(message);
        }
    }

    private boolean isSpecialRequest(HttpServletRequest request, Object handler) {
        String url = request.getRequestURI();
        if (EXCLUDE_PATHS.contains(url)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/error");
    }
}

