package cn.com.duiba.cloud.manage.service.sdk.controller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.RedisKeyEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppCookieQueryParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteAppService;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/1/10 10:01
 */
@Slf4j
@Controller
@RequestMapping("appClient")
public class AppClientController {

    @Resource
    private RemoteAppService remoteAppService;

    /**
     * saas平台跳转需要
     */
    @RequestMapping("index")
    public String index(@RequestParam Long innerUserId,
                        @RequestParam Long tenantId,
                        @RequestParam(required = false) String redirect) throws BizException {
        return handleIndex(innerUserId, tenantId, redirect);
    }

    /**
     * erp 做跳转需要
     */
    @RequestMapping("erpIndex")
    @CanAccess
    public String erpIndex(@RequestParam Long innerUserId,
                        @RequestParam Long tenantId,
                        @RequestParam(required = false) String redirect) throws BizException {
        return handleIndex(innerUserId, tenantId, redirect);
    }

    private String handleIndex(Long innerUserId, Long tenantId, String redirect) throws BizException {
        RemoteAppCookieQueryParam param = new RemoteAppCookieQueryParam();
        String key = RedisKeyEnum.getRedisKey(RedisKeyEnum.APP_COOKIE_INFO, innerUserId, tenantId);
        param.setKey(key);
        List<Cookie> cookieList = remoteAppService.getAppCookieInfo(param);
        if (CollectionUtils.isEmpty(cookieList)) {
            throw new BizException("无效的cookie信息");
        }
        for (Cookie cookie : cookieList) {
            Cookie newCookie = CookieUtil.createCookie(cookie.getName(), cookie.getValue(), cookie.getMaxAge());
            SsoRequestTool.addCookie(newCookie);
        }
        return "redirect:" + redirect;
    }

}
