package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtNotCheckTenantApp;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteTenantHasAppParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtCustomerService;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Objects;

/**
 * 校验应用信息是否正常
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/1/12
 */
@Slf4j
public class TenantAppHandler implements SsoFilterHandler {

    @Resource
    private RemoteMgtCustomerService remoteMgtCustomerService;

    @Override
    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;
            MgtNotCheckTenantApp rights = AnnotationUtils.findAnnotation(method.getMethod(), MgtNotCheckTenantApp.class);
            Long tenantAppId = LoginUtil.getTenantAppIdOrNull();
            // 为空不校验
            if (Objects.isNull(tenantAppId) || Objects.nonNull(rights)) {
                return Boolean.TRUE;
            }

            try {
                Long tenantId = null;
                Long staffId = null;
                Boolean valid = false;
                try {
                    tenantId = LoginUtil.getTenantId();
                    staffId = LoginUtil.getStaffId();
                    RemoteTenantHasAppParam remoteParam = new RemoteTenantHasAppParam();
                    remoteParam.setTenantId(tenantId);
                    remoteParam.setTenantAppId(tenantAppId);
                    valid = remoteMgtCustomerService.tenantHasApp(remoteParam);
                } catch (BizException e) {
                    log.error("query tenantAppId error ! tenantId:{},tenantAppId:{},staffId:{},errCode:{},errMsg:{}", tenantId, tenantAppId, staffId, e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return Boolean.FALSE;
                }

                if (!valid) {
                    log.warn("tenantAppId not valid ! tenantId:{},tenantAppId:{},staffId:{}", tenantId, tenantAppId, staffId);
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(ErrorCode.APP_INFO_INVALID.getCode(), ErrorCode.APP_INFO_INVALID.getMsg());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return Boolean.FALSE;
                }

            } catch (IOException e) {
                throw new SsoRunTimeException(e);
            }

        }
        return Boolean.TRUE;

    }

    @Override
    public int getOrder() {
        return 25;
    }
}
