package cn.com.duiba.cloud.manage.service.sdk.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @program: duiba-manage-service
 * @description: 权益验证拦截
 * @author: 郭云龙
 * @create: 2022-05-07 14:37
 * 拦截指定字段权益用于验证是否具有指定权益，一般用于标记到组件或活动
 **/
@Retention(RetentionPolicy.RUNTIME)
//@Target({ElementType.METHOD,ElementType.FIELD, ElementType.PARAMETER})
@Target({ElementType.METHOD})
@Documented
@Inherited
public @interface MgtRightsVerity {

    /**
     * 指定验证字段,必须指定
     */
    String fieldVerity();

    /**
     * 指定权益Code前缀
     * @return
     */
    String prefixRightsCode();

    /**
     * 无权限的提示信息
     * @return
     */
    String message() default "无权访问该资源";

//    enum RightsFieldType{
//        ACTIVITY,MODULE,BLOCK;
//
//    }
}
