package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.sdk.config.CookieConfig;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.TokenCookieDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteCachedStaffInfoParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtCustomerService;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/12 14:45
 */
@Component
@Slf4j
public class CustomHandler implements SsoFilterHandler {

    @Resource
    private RemoteMgtCustomerService remoteMgtCustomerService;

    @Override
    public Boolean before(Object handler) throws SsoException {
        LoginUtil.checkUserId();
        String manageTku = SsoRequestTool.getCookie(CookieConfig.COOKIE_NAME);
        TokenCookieDTO tokenCookieDTO = JSONObject.parseObject(
                BlowfishUtils.decryptBlowfish(manageTku, CookieConfig.KEY_ENCRYPT), TokenCookieDTO.class);
        JSONObject adminInfo = SsoRequestTool.getRequestParams().getAdminInfo();

        // 校验缓存中是否还有该员工在当前租户下的信息
        if (tokenCookieDTO.getTenantId() != null) {
            RemoteCachedStaffInfoParam rp = new RemoteCachedStaffInfoParam();
            rp.setTenantId(tokenCookieDTO.getTenantId());
            rp.setInnerUserId(tokenCookieDTO.getInnerUserId());
            String value = remoteMgtCustomerService.cachedStaffInfo(rp);
            if (value == null) {
                LoginUtil.saveCookie(LoginUtil.getCookieUserId(), null, null);
                try {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(ErrorCode.TENANT_NOT_NULL.getCode(),
                            ErrorCode.TENANT_NOT_NULL.getMsg());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));

                    return Boolean.FALSE;
                } catch (IOException e) {
                    throw new SsoRunTimeException(e);
                }
            }
        }

        adminInfo.put("staffId", tokenCookieDTO.getStaffId());
        adminInfo.put("tenantId", tokenCookieDTO.getTenantId());
        adminInfo.put("tenantAppId", LoginUtil.getTenantAppIdOrNull());

        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 20;
    }
}
