package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRightsVerity;
import cn.com.duiba.cloud.manage.service.sdk.constant.MgtSdkConstant;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

/**
 * @program: duiba-manage-service
 * @description: 字段级权益拦截
 * @author: 郭云龙
 * @create: 2022-05-07 15:21
 **/
@Slf4j
public class MgtRightsVerityHandler implements SsoFilterHandler {


    @Resource
    private PermissionVerification permissionVerification;

    @Override
    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;

            MgtRightsVerity mgtRightsVerify = AnnotationUtils.getAnnotation(method.getMethod(), MgtRightsVerity.class);

            //如果注解不存在，直接返回
            if(Objects.isNull(mgtRightsVerify)){
                return Boolean.TRUE;
            }

            Map<String, String> requestParamMap = SsoRequestTool.getRequestParamMap();
            try {
                try {
                    Long tenantId = LoginUtil.getTenantId();
                    Long staffId = LoginUtil.getStaffId();
                    Long tenantAppId = LoginUtil.getTenantAppId();
                    //根据MgtRightsField的fieldName获取用于判断的参数内容
                    //缺失前缀，可能导致判断错误，活动的ID与组件ID相同
                    String rightsVerityCode = requestParamMap.get(mgtRightsVerify.fieldVerity());
                    Boolean verifyRightsField = permissionVerification.verifyRightsField(tenantId, tenantAppId,
                            mgtRightsVerify.prefixRightsCode().concat(rightsVerityCode));
                    if(verifyRightsField){
                        return Boolean.TRUE;
                    }
                    log.warn("tenantId:{},tenantAppId:{},staffId:{},rightsVerityCode:{}", tenantId, tenantAppId, staffId,rightsVerityCode);
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(MgtSdkConstant.NO_RIGHTS_CODE, mgtRightsVerify.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return Boolean.FALSE;
                } catch (BizException e) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail(e.getCode(), e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString(result));
                    return false;
                }
            } catch (IOException e) {
                throw new SsoRunTimeException(e);
            }

        }
        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 29;
    }
}
