/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.sdk.config.CookieConfig;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.TokenCookieDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.param.RemoteCachedStaffInfoParam;
import cn.com.duiba.cloud.manage.service.sdk.remoteservice.RemoteMgtCustomerService;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomHandler.class);
    @Resource
    private RemoteMgtCustomerService remoteMgtCustomerService;

    public Boolean before(Object handler) throws SsoException {
        LoginUtil.checkUserId();
        String manageTku = SsoRequestTool.getCookie((String)CookieConfig.COOKIE_NAME);
        TokenCookieDTO tokenCookieDTO = (TokenCookieDTO)JSONObject.parseObject((String)BlowfishUtils.decryptBlowfish((String)manageTku, (String)CookieConfig.KEY_ENCRYPT), TokenCookieDTO.class);
        JSONObject adminInfo = SsoRequestTool.getRequestParams().getAdminInfo();
        if (tokenCookieDTO.getTenantId() != null) {
            RemoteCachedStaffInfoParam rp = new RemoteCachedStaffInfoParam();
            rp.setTenantId(tokenCookieDTO.getTenantId());
            rp.setInnerUserId(tokenCookieDTO.getInnerUserId());
            String value = this.remoteMgtCustomerService.cachedStaffInfo(rp);
            if (value == null) {
                LoginUtil.saveCookie(LoginUtil.getCookieUserId(), null, null);
                try {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)ErrorCode.TENANT_NOT_NULL.getCode(), (String)ErrorCode.TENANT_NOT_NULL.getMsg());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return Boolean.FALSE;
                }
                catch (IOException e) {
                    throw new SsoRunTimeException((Throwable)e);
                }
            }
        }
        adminInfo.put("staffId", (Object)tokenCookieDTO.getStaffId());
        adminInfo.put("tenantId", (Object)tokenCookieDTO.getTenantId());
        adminInfo.put("tenantAppId", (Object)LoginUtil.getTenantAppIdOrNull());
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 20;
    }
}

