/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRightsVerity;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class MgtRightsVerityHandler
implements SsoFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(MgtRightsVerityHandler.class);
    @Resource
    private PermissionVerification permissionVerification;

    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            MgtRightsVerity mgtRightsVerify = (MgtRightsVerity)AnnotationUtils.getAnnotation((Method)method.getMethod(), MgtRightsVerity.class);
            if (Objects.isNull(mgtRightsVerify)) {
                return Boolean.TRUE;
            }
            Map requestParamMap = SsoRequestTool.getRequestParamMap();
            try {
                try {
                    Long tenantId = LoginUtil.getTenantId();
                    Long staffId = LoginUtil.getStaffId();
                    Long tenantAppId = LoginUtil.getTenantAppId();
                    String rightsVerityCode = (String)requestParamMap.get(mgtRightsVerify.fieldVerity());
                    Boolean verifyRightsField = this.permissionVerification.verifyRightsField(tenantId, tenantAppId, mgtRightsVerify.prefixRightsCode().concat(rightsVerityCode));
                    if (verifyRightsField.booleanValue()) {
                        return Boolean.TRUE;
                    }
                    log.warn("tenantId:{},tenantAppId:{},staffId:{},rightsVerityCode:{}", new Object[]{tenantId, tenantAppId, staffId, rightsVerityCode});
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)"mss000002", (String)mgtRightsVerify.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return Boolean.FALSE;
                }
                catch (BizException e) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)e.getCode(), (String)e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return false;
                }
            }
            catch (IOException e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 29;
    }
}

