/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.util;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.cloud.manage.service.sdk.config.CookieConfig;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.ParamHeaderDTO;
import cn.com.duiba.cloud.manage.service.sdk.model.dto.TokenCookieDTO;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.CharsetUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);
    public static final String KEY_REQUEST_USERAGENT = "User-Agent";

    private RequestUtils() {
    }

    public static String getCookie(HttpServletRequest request, String key) {
        return RequestUtils.getCookies(request).get(key);
    }

    public static Map<String, String> getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (Objects.isNull(cookies)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> cookieMap = new HashMap<String, String>(16);
        for (Cookie c : cookies) {
            cookieMap.put(c.getName(), c.getValue());
        }
        return cookieMap;
    }

    public static String getLoginCookieValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        if ((SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) && StringUtils.isNotBlank((CharSequence)(value = request.getParameter(key)))) {
            return value;
        }
        return RequestUtils.getCookie(request, key);
    }

    public static TokenCookieDTO getTokenCookie(String tkv) {
        if (StringUtils.isBlank((CharSequence)tkv) || "undefined".equals(tkv) || StringUtils.equals((CharSequence)tkv, (CharSequence)"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)tkv, (String)CookieConfig.KEY_ENCRYPT);
            return (TokenCookieDTO)JSON.parseObject((String)content, TokenCookieDTO.class);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790Token\u9519\u8bef {}", (Object)tkv, (Object)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(JSONObject.toJSONString((Object)Base64.decodeStr((CharSequence)URLDecoder.decode((String)"eyJ0ZW5hbnRBcHBJZCI6NDEzfQ==", (Charset)CharsetUtil.CHARSET_UTF_8))));
        System.out.println(JSONObject.toJSONString((Object)Base64.decodeStr((CharSequence)URLDecoder.decode((String)"eyJ0ZW5hbnRBcHBJZCI6NDAxfQ==", (Charset)CharsetUtil.CHARSET_UTF_8))));
    }

    public static Map<String, Object> getParameters(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        if (MapUtils.isEmpty((Map)paramMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(paramMap.size());
        paramMap.forEach((k, v) -> resultMap.put((String)k, ((String[])v).length >= 1 ? v[0] : v));
        return resultMap;
    }

    public static Map<String, List<String>> getAllHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null || !headerNames.hasMoreElements()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(16);
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            ArrayList valueList = new ArrayList();
            headers.put(name, valueList);
            Enumeration values = request.getHeaders(name);
            if (values == null || !values.hasMoreElements()) continue;
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
        }
        return headers;
    }

    public static String getUserAgent(HttpServletRequest request) {
        String ua = request.getHeader(KEY_REQUEST_USERAGENT);
        if (StringUtils.isBlank((CharSequence)ua)) {
            return "";
        }
        return ua.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInputSteam(HttpServletRequest request) {
        try (ServletInputStream in = request.getInputStream();){
            int n;
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[1024];
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6RequestInputStream\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public static String generateToken(TokenCookieDTO tokenCookie) {
        String value = JSON.toJSONString((Object)tokenCookie);
        return BlowfishUtils.encryptBlowfish((String)value, (String)CookieConfig.KEY_ENCRYPT);
    }

    public static ParamHeaderDTO getCookieParam(HttpServletRequest request) {
        String paramCookie = request.getHeader(CookieConfig.PARAM_HEADER);
        if (StringUtils.isBlank((CharSequence)paramCookie)) {
            return null;
        }
        String decodeStr = Base64.decodeStr((CharSequence)URLDecoder.decode((String)paramCookie, (Charset)CharsetUtil.CHARSET_UTF_8));
        return (ParamHeaderDTO)JSON.parseObject((String)decodeStr, ParamHeaderDTO.class);
    }

    public static String pkgCookieParam(Long tenantAppId) {
        ParamHeaderDTO paramCookie = new ParamHeaderDTO();
        paramCookie.setTenantAppId(tenantAppId);
        return URLEncodeUtil.encode((String)Base64.encode((CharSequence)JSON.toJSONString((Object)paramCookie)));
    }
}

