/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRights;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.manage.service.sdk.model.VerifyRightsRes;
import cn.com.duiba.cloud.manage.service.sdk.util.LoginUtil;
import cn.com.duiba.cloud.manage.service.sdk.util.PermissionUtil;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class MgtRightsHandler
implements SsoFilterHandler {
    @Resource
    private PermissionVerification permissionVerification;

    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            MgtRights rights = (MgtRights)AnnotationUtils.findAnnotation((Method)method.getMethod(), MgtRights.class);
            if (Objects.isNull(rights)) {
                return Boolean.TRUE;
            }
            String code = rights.code();
            try {
                VerifyRightsRes res = null;
                try {
                    Long tenantId = LoginUtil.getTenantId();
                    Long tenantAppId = LoginUtil.getTenantAppId();
                    res = this.permissionVerification.verifyRights(tenantId, tenantAppId, code);
                }
                catch (BizException e) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)e.getCode(), (String)e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return false;
                }
                if (res == null || !res.getAccess().booleanValue()) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)"mss000002", (String)rights.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return false;
                }
                String content = res.getContent();
                if (StringUtils.isNotBlank((CharSequence)content)) {
                    Map contentMap = (Map)JSONObject.parseObject((String)content, Map.class);
                    PermissionUtil.putAll(contentMap);
                }
                return Boolean.TRUE;
            }
            catch (IOException e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 30;
    }
}

