package cn.com.duiba.cloud.manage.service.sdk.util;

import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Objects;

/**
 * 权益、权限工具类
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/17
 */
public class PermissionUtil {

    /**
     * 获取string类型的key
     * @param key
     * @return
     */
    public static String getString(String key) {
        Object val = get(key);
        if (Objects.isNull(val)) {
            return null;
        }
        return String.valueOf(val);
    }

    /**
     * 获取Long类型的key
     * @param key
     * @return
     */
    public static Long getLong(String key) {
        Object val = get(key);
        if (Objects.isNull(val)) {
            return null;
        }
        return Long.valueOf(val.toString());
    }

    /**
     * 获取值int类型的key
     * @param key
     * @return
     */
    public static Integer getInt(String key) {
        Object val = get(key);
        if (Objects.isNull(val)) {
            return null;
        }
        return Integer.valueOf(val.toString());
    }

    /**
     * 将value转换成传入的类
     * @param key
     * @param classType
     * @param <T>
     * @return
     */
    public static <T> T get(String key, Class<T> classType) {
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("key不能为空");
        }
        if (Objects.isNull(classType)) {
           throw new IllegalArgumentException("请传入具体的class类型");
        }
        Object val = getAdminInfo().get(key);
        if (Objects.isNull(val)) {
            return null;
        }
        return JSONObject.parseObject(String.valueOf(val), classType);
    }

    /**
     * 通过key获取value
     * @param key
     * @return
     */
    public static Object get(String key) {
        if (StringUtils.isBlank(key)) {
            throw new IllegalArgumentException("key不能为空");
        }
        return getAdminInfo().get(key);
    }

    /**
     * 添加全部map
     */
    public static void putAll(Map<String, Object> contentMap) {
        if (CollectionUtils.isEmpty(contentMap)) {
            return;
        }
        for (String key : contentMap.keySet()) {
            put(key, contentMap.get(key));
        }
    }

    /**
     * 添加一个
     * @param key
     * @param value
     */
    public static void put(String key, Object value) {
        if (StringUtils.isBlank(key) || Objects.isNull(value)) {
            throw new IllegalArgumentException("键值对不能为空");
        }
        getAdminInfo().put(key, value);
    }

    /**
     * 获取sso的adminInfo，用于存放当前线程的参数
     * @return
     */
    private static JSONObject getAdminInfo() {
        return SsoRequestTool.getRequestParams().getAdminInfo();
    }

}
