/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.measurement.client.service;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.measurement.client.MeasureClient;
import cn.com.duiba.cloud.measurement.client.configuration.MeasurementConfig;
import cn.com.duiba.cloud.measurement.client.configuration.MeasurementProperties;
import cn.com.duiba.cloud.measurement.client.domain.MeasureAware;
import cn.com.duiba.cloud.measurement.client.domain.MeasureChangeResultDto;
import cn.com.duiba.cloud.measurement.client.domain.MeasureDto;
import cn.com.duiba.cloud.measurement.client.domain.MeasureTypeDto;
import cn.com.duiba.cloud.measurement.client.domain.params.ChangeMeasureParams;
import cn.com.duiba.cloud.measurement.client.domain.params.CreateMeasureParams;
import cn.com.duiba.cloud.measurement.client.domain.params.LimitType;
import cn.com.duiba.cloud.measurement.client.domain.params.MeasureRange;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureService;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureTypeService;
import cn.com.duiba.cloud.measurement.client.service.MeasureTransactionManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;

public class MeasureClientImpl
implements MeasureClient {
    private static final Logger log = LoggerFactory.getLogger(MeasureClientImpl.class);
    @Value(value="${spring.application.name}")
    private String appId;
    @Resource
    private MeasurementProperties measurementProperties;
    @Resource
    private MeasureTransactionManager measureTransactionManager;
    @Resource
    private RemoteMeasureService remoteMeasureService;
    @Resource
    private RemoteMeasureTypeService remoteMeasureTypeService;
    private final Set<String> supportMeasureTypes = Sets.newHashSet();

    @EventListener(value={MainContextRefreshedEvent.class})
    public void init() throws BizException {
        ArrayList types = Lists.newArrayList();
        for (String measureType : this.measurementProperties.getTypes().keySet()) {
            MeasurementConfig config = this.measurementProperties.getTypes().get(measureType);
            if (!config.getEnable().booleanValue()) continue;
            MeasureTypeDto dto = new MeasureTypeDto();
            dto.setKey(measureType);
            types.add(dto);
        }
        if (types.isEmpty()) {
            return;
        }
        this.supportMeasureTypes.addAll(this.remoteMeasureTypeService.initMeasureTypes(this.appId, types));
    }

    @Override
    public String createMeasure(CreateMeasureParams params) throws BizException {
        if (!this.supportMeasureTypes.contains(params.getMeasureType())) {
            throw new UnsupportedOperationException("\u6ca1\u6709\u8ba1\u91cf\u7c7b\u578b\u3010" + params.getMeasureType() + "\u3011\u7684\u4f7f\u7528\u6743\u9650");
        }
        return this.remoteMeasureService.createMeasure(params);
    }

    @Override
    public List<String> createMeasureByNum(CreateMeasureParams params, Integer applyMeasureNum) throws BizException {
        if (!this.supportMeasureTypes.contains(params.getMeasureType())) {
            throw new UnsupportedOperationException("\u6ca1\u6709\u8ba1\u91cf\u7c7b\u578b\u3010" + params.getMeasureType() + "\u3011\u7684\u4f7f\u7528\u6743\u9650");
        }
        return this.remoteMeasureService.createMeasureByNum(params, applyMeasureNum);
    }

    @Override
    public List<String> createMeasureByConfig(List<CreateMeasureParams> params) throws BizException {
        for (CreateMeasureParams item : params) {
            if (this.supportMeasureTypes.contains(item.getMeasureType())) continue;
            throw new UnsupportedOperationException("\u6ca1\u6709\u8ba1\u91cf\u7c7b\u578b\u3010" + item.getMeasureType() + "\u3011\u7684\u4f7f\u7528\u6743\u9650");
        }
        return this.remoteMeasureService.createMeasureByConfig(params);
    }

    @Override
    public Long findMeasureOnlyValue(String measureId) {
        return this.remoteMeasureService.findMeasureOnlyValue(measureId);
    }

    @Override
    public Map<String, Long> batchFindMeasureOnlyValue(List<String> measureIds) {
        if (measureIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.remoteMeasureService.batchFindMeasureOnlyValue(measureIds);
    }

    @Override
    public void bindMeasureValue(List<MeasureAware> measureObjects) {
        if (measureObjects.isEmpty()) {
            return;
        }
        List<String> measureIds = measureObjects.stream().map(MeasureAware::getMeasureId).distinct().collect(Collectors.toList());
        Map<String, Long> measureValues = this.remoteMeasureService.batchFindMeasureOnlyValue(measureIds);
        for (MeasureAware measureAware : measureObjects) {
            String measureId = measureAware.getMeasureId();
            Long value = measureValues.get(measureId);
            measureAware.setMeasureValue(value);
        }
    }

    @Override
    public void changeMeasureRange(String measureId, Long lowerLimit, Long upperLimit) throws BizException {
        MeasureRange range = new MeasureRange();
        range.setLowerLimit(lowerLimit);
        range.setUpperLimit(upperLimit);
        this.remoteMeasureService.updateLimit(measureId, range);
    }

    @Override
    public MeasureChangeResultDto changeMeasure(String measureId, String bizNo, Long delta) throws BizException {
        return this.changeMeasure(measureId, bizNo, delta, false);
    }

    @Override
    public MeasureChangeResultDto changeMeasure(String measureId, String bizNo, Long delta, Boolean isBack) throws BizException {
        ChangeMeasureParams params = new ChangeMeasureParams();
        params.setMeasureId(measureId);
        params.setBizNo(bizNo);
        if (isBack.booleanValue()) {
            params.setBizNo(params.getBizNo() + "-back");
            params.setLimitType(LimitType.NONE);
        } else {
            params.setLimitType(LimitType.STRICT);
        }
        params.setChangeValue(delta);
        MeasureChangeResultDto changeResult = this.remoteMeasureService.changeMeasure(params);
        if (this.measureTransactionManager.isTransaction()) {
            this.measureTransactionManager.accept(changeResult);
        }
        return changeResult;
    }

    @Override
    public MeasureChangeResultDto updateMeasure(String measureId, Long value) throws BizException {
        MeasureChangeResultDto changeResult = this.remoteMeasureService.updateValue(measureId, value);
        if (this.measureTransactionManager.isTransaction()) {
            this.measureTransactionManager.accept(changeResult);
        }
        return changeResult;
    }

    @Override
    public Map<String, MeasureChangeResultDto> changeMultiMeasure(List<String> measureIds, String bizNo, Long totalDelta) throws BizException {
        if (measureIds.isEmpty()) {
            return Collections.emptyMap();
        }
        long changeValue = totalDelta;
        HashMap result = Maps.newHashMap();
        AtomicInteger sequence = new AtomicInteger(0);
        ArrayList flowIds = Lists.newArrayList();
        try {
            for (String measureId : measureIds) {
                if (result.containsKey(measureId)) {
                    throw new BizException("\u8ba1\u91cf\u3010" + measureId + "\u3011\u4f20\u5165\u91cd\u590d");
                }
                int index = sequence.getAndIncrement();
                ChangeMeasureParams params = new ChangeMeasureParams();
                params.setMeasureId(measureId);
                params.setChangeValue(changeValue);
                params.setBizNo(bizNo);
                LimitType limitType = index == measureIds.size() - 1 ? LimitType.STRICT : LimitType.WEAK;
                params.setLimitType(limitType);
                MeasureChangeResultDto changeResult = this.remoteMeasureService.changeMeasure(params);
                if (this.measureTransactionManager.isTransaction()) {
                    this.measureTransactionManager.accept(changeResult);
                }
                result.put(measureId, changeResult);
                flowIds.add(changeResult.getFlowId());
                if (!Objects.equals(changeValue, changeResult.getChangeValue())) {
                    changeValue -= changeResult.getChangeValue().longValue();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.remoteMeasureService.rollbackMeasures(flowIds);
            throw e;
        }
        return result;
    }

    @Override
    public MeasureDto cleanMeasure(String measureId) throws BizException {
        return this.remoteMeasureService.clearMeasure(measureId);
    }
}

