/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.measurement.client.service;

import cn.com.duiba.cloud.measurement.client.domain.MeasureChangeResultDto;
import cn.com.duiba.cloud.measurement.client.exception.MeasureException;
import cn.com.duiba.cloud.measurement.client.remoteserver.RemoteMeasureService;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(MeasureTransactionManager.class);
    private final ThreadLocal<String> transactionIdThreadLocal = new ThreadLocal();
    private final Cache<String, List<String>> context = Caffeine.newBuilder().removalListener((RemovalListener)new RemovalListener<String, List<String>>(){

        public void onRemoval(@Nullable String key, @Nullable List<String> flows, @NonNull RemovalCause cause) {
            if (!Objects.equals(cause, RemovalCause.EXPIRED)) {
                return;
            }
            if (Objects.isNull(flows)) {
                return;
            }
            try {
                MeasureTransactionManager.this.remoteMeasureService.rollbackMeasures(Lists.newArrayList(flows));
            }
            catch (Exception e) {
                log.error("\u56de\u6eda\u5931\u8d25", (Throwable)e);
            }
        }
    }).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    @Resource
    private RemoteMeasureService remoteMeasureService;

    public void accept(MeasureChangeResultDto result) {
        String transactionId = this.transactionIdThreadLocal.get();
        if (Objects.isNull(transactionId)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        List flows = (List)this.context.getIfPresent((Object)transactionId);
        if (Objects.isNull(flows)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        flows.add(result.getFlowId());
    }

    public void beginTransaction() {
        String transactionId = UUIDUtils.createUUID();
        this.transactionIdThreadLocal.set(transactionId);
        this.context.put((Object)transactionId, (Object)Lists.newArrayList());
    }

    public void commit() {
        String transactionId = this.transactionIdThreadLocal.get();
        if (Objects.isNull(transactionId)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        this.context.invalidate((Object)transactionId);
    }

    public void rollback() {
        String transactionId = this.transactionIdThreadLocal.get();
        if (Objects.isNull(transactionId)) {
            throw new MeasureException("\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u5904\u4e8e\u8ba1\u91cf\u4e8b\u52a1\u4e2d");
        }
        try {
            List flows = (List)this.context.getIfPresent((Object)transactionId);
            if (Objects.isNull(flows) || flows.isEmpty()) {
                return;
            }
            this.remoteMeasureService.rollbackMeasures(flows);
        }
        catch (Exception e) {
            log.error("\u56de\u6eda\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.transactionIdThreadLocal.remove();
        }
    }

    public boolean isTransaction() {
        String transactionId = this.transactionIdThreadLocal.get();
        return Objects.nonNull(transactionId) && Objects.nonNull(this.context.getIfPresent((Object)transactionId));
    }
}

