# 计量中心

## 1.介绍
计量中心用于将关系型记录的热点计数字段从业务表中剥离，避免对业务表记录产生行锁，从而整体提升数据库设计的性能  
计量中心引入了缓存，热点数据更新技术（Inventory Hint），查询和更新性能优秀  
同时引入事务机制（不可重复读）可批量对已操作的计量进行回滚，调用上，保障幂等性，杜绝重复提交带来错误  
计量中心还支持设置计量上下限，很好的解决超卖和限量的问题

曾经，我们或许做过秒杀相关的需求，我们需要预热，需要库存预加载，我们总以解决库存的行锁问题而骄傲和自豪。
但是在整个业务系统的中，热点字段可不仅仅只有库存，有商家的预算，有商家的付费账户，有定向库存，有一系列的限制计量
一个环节没有考虑到，整体性能就会大打折扣。  
热点字段的存在不仅仅只是行锁带来的性能问题，还会使记录对应的缓存更新频率异常的高，最后发现对数据库的压力并没有减小
计量中心的引入将热点字段和冷字段分离，后面我们可以不需要专注于秒杀功能，我们的目标是：所有开发出的需求天然就能支持秒杀

接入方式
```
compile "cn.com.duiba.cloud.measurement:measurement-client:0.0.5"
```

## 2.配置

```
配置格式
```
duiba.cloud.measurement.types.[计量类型].enable = true
```
注意：计量类型只能下划线加字母进行定义
```

## 3.使用

计量管理
```
    @Resource
    private RemoteMeasureService remoteMeasureService;
    
```
通过 RemoteMeasureService 可以对计量进行常规管理，比如计量的创建和删除，上下限的设置，查询

与计量中心的整合的套路就是，把原来数据库中的计量字段换成通过创建计量得到的计量id,然后通过计量id
和计量中心完成后面的交互

```
    @Resource
    private MeasureClientManager measureClientManager;
    
    @GetMapping("/add")
    public String add() throws BizException {
        MeasureClient measureClient = measureClientManager.getMeasureClient("计量类型");
        measureClient.changeMeasure(1L, UUIDUtils.createUUID(),1L);
        return "ok";
    }

    @GetMapping("/reduce")
    public String reduce() throws BizException {
        MeasureClient measureClient = measureClientManager.getMeasureClient("计量类型");
        measureClient.changeMeasure(1L, UUIDUtils.createUUID(),-1L);
        return "ok";
    }
    
```
示例中通过UUID模拟唯一的单据流水号，对计量类型下id为1的计量进行增加和减少的操作
在计量操作的过程中可能存在异常，通过从BizException中获取code进行判断
```
/**
* 计量不存在
*/
public static final String MEASURE_NOT_EXIST = "10000";
/**
* 达到上限
*/
public static final String REACH_THE_UPPER_LIMIT = "10001";
/**
* 达到下限
*/
public static final String REACH_THE_LOWER_LIMIT = "10002";
```

在一些预扣库存，预扣资金的通常会存在返库存和返资金的情况，但是因为单据号只有一个，无法通过计量中心的幂等性判断
因此计量客户端对changeMeasure方法实现了重载

ps:计量中心的幂等性保障不是永久的，只能保持30分钟的幂等性保障，计量中心希望将永久性的幂等性的判断交给业务层的流水单

```
/**
     * 计量变更
     * @param measureId 计量id
     * @param bizNo 业务单号,计量中心以此
     * @param delta 变化量
     * @param isBack 在业务级别进行返回操作，比如返库存，返资金，此时会对业务单号进行修饰，以通过幂等校验
     * @throws BizException code see MeasureErrorCode
     */
    public MeasureChangeResultDto changeMeasure(Long measureId, String bizNo, Long delta,boolean isBack) throws BizException {
        ChangeMeasureParams params = new ChangeMeasureParams();
        params.setMeasureId(measureId);
        if(isBack){
            params.setBizNo(bizNo+"-back");
        }else{
            params.setBizNo(bizNo);
        }
        params.setTransactionId(transactionIdThreadLocal.get());
        params.setChangeValue(delta);
        return remoteMeasureService.changeMeasure(measureType,params);
    }
```
在方法中引入了isBack参数，表示对原来进行返回

## 4.事务
在引入Inventory Hint 技术后，update的操作就脱离了事务的管束，计量中心自行设计事务机制，隔离级别：不可重读
可以对一个计量事务中的操作进行批量回滚

事务超时时间：30秒，也就是30秒之内不提交事务，事务会自动回滚

```
    @Resource
    private MeasureClientManager measureClientManager;
    @Resource
    private MeasureTransactionManager measureTransactionManager;

    @GetMapping("/commit")
    public String commit() throws BizException {
        MeasureClient measureClient = measureClientManager.getMeasureClient("test");
        //外部业务事务
        try{
            //开启计量事务
            measureTransactionManager.beginTransaction();
            //产生业务流水
            String bizNo = UUIDUtils.createUUID();

            measureClient.changeMeasure("1-1-1", bizNo,1L);
            measureClient.changeMeasure("1-1-2", bizNo,2L);

            measureTransactionManager.commit();
        }catch (Exception e){
            log.error("异常");
            //计量事务回滚
            measureTransactionManager.rollback();
            //异常触发外部业务事务回滚
            throw e;
        }
        return "OK";
    }
```