/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.zhongyan.goods.center.api.util;

import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.AbstractGoodsDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.GoodsDetailDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.GoodsDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods.SpuDto;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.Labels;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GoodsSnapshotUtil {
    public static final String LABEL_SNAPSHOT = "snapshot";
    public static final String LABEL_TENANT = "tenant";
    public static final String LABEL_SUPPLIER = "supplier";
    private static final String SPLIT = "@";

    public static Pair<String, String> getSupplierSnapshotStr(GoodsDto goodsDto) {
        String s = JSON.toJSONString((Object)goodsDto, (SerializeFilter)Labels.includes((String[])new String[]{LABEL_SNAPSHOT, LABEL_SUPPLIER}), (SerializerFeature[])new SerializerFeature[0]);
        System.out.println("supplier:" + s);
        return Pair.from((Object)GoodsSnapshotUtil.getSupplierSnapshotId(goodsDto), (Object)s);
    }

    public static String getSupplierSnapshotId(GoodsDto goodsDto) {
        SpuDto spuDto = goodsDto.getSpuDto();
        return spuDto.getId() + "_" + GoodsSnapshotUtil.getDateSecondStr(spuDto.getGmtModified());
    }

    private static String getDateSecondStr(Date date) {
        return String.valueOf(date.getTime() / 1000L);
    }

    public static Pair<String, String> getTenantSnapshotStr(GoodsDto goodsDto) {
        String s = JSON.toJSONString((Object)goodsDto, (SerializeFilter)Labels.includes((String[])new String[]{LABEL_SNAPSHOT, LABEL_TENANT}), (SerializerFeature[])new SerializerFeature[0]);
        System.out.println("tenant:" + s);
        return Pair.from((Object)GoodsSnapshotUtil.getTenantSnapshotId(goodsDto), (Object)s);
    }

    public static String getTenantSnapshotId(GoodsDto goodsDto) {
        GoodsDetailDto detail = goodsDto.getSpuDto().getDetail();
        return String.format("%s_%s_%s_%s", detail.getGeneralId(), GoodsSnapshotUtil.getDateSecondStr(detail.getGmtModified()), detail.getUserId(), detail.getUserType());
    }

    public static void assembleGoods(GoodsDto goodsDto, String supplierSnapshotStr, String tenantSnapshotStr, Long skuId) {
        GoodsDto supplierSnapshotDto = (GoodsDto)JSONObject.parseObject((String)supplierSnapshotStr, GoodsDto.class);
        GoodsDto tenantSnapshotDto = (GoodsDto)JSONObject.parseObject((String)tenantSnapshotStr, GoodsDto.class);
        System.out.println("\u53d6\u56de\u67651" + JSON.toJSONString((Object)supplierSnapshotDto));
        System.out.println("\u53d6\u56de\u67652" + JSON.toJSONString((Object)tenantSnapshotDto));
        BeanUtils.copy((Object)supplierSnapshotDto, (Object)goodsDto);
        if (skuId != null) {
            goodsDto.setSkuList(goodsDto.getSkuList().stream().filter(skuDto -> Objects.equals(skuDto.getId(), skuId)).collect(Collectors.toList()));
        }
        ArrayList dest = Lists.newArrayList((Object[])new AbstractGoodsDto[]{goodsDto.getSpuDto()});
        dest.addAll(goodsDto.getSkuList());
        ArrayList source = Lists.newArrayList((Object[])new AbstractGoodsDto[]{tenantSnapshotDto.getSpuDto()});
        source.addAll(tenantSnapshotDto.getSkuList());
        Map generalKeyMap = source.stream().collect(Collectors.toMap(GeneralBiz::generalKey, Function.identity()));
        for (AbstractGoodsDto dto : dest) {
            AbstractGoodsDto abstractGoodsDto = (AbstractGoodsDto)generalKeyMap.get(dto.generalKey());
            if (abstractGoodsDto == null) continue;
            dto.setDetail(abstractGoodsDto.getDetail());
            dto.setImageList(abstractGoodsDto.getImageList());
        }
    }

    public static Pair<String, String> splitSnapshot(String snapshotId) {
        String[] split = snapshotId.split(SPLIT);
        return Pair.from((Object)split[0], (Object)split[1]);
    }

    public static String combineSnapshot(String supplierSnapshotId, String tenantSnapshotId) {
        return supplierSnapshotId + SPLIT + tenantSnapshotId;
    }
}

