package cn.com.duiba.cloud.zhongyan.goods.center.api.constant;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * 属性状态枚举
 *
 * @author xuanhongjian
 */
@Getter
public enum AttributeStateEnum {
    /**
     * 属性现存状态
     */
    ON("开启", 1),
    OFF("关闭", 0);

    private static final ImmutableMap<Integer, AttributeStateEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, AttributeStateEnum> builder = ImmutableMap.builder();
        for (AttributeStateEnum item : AttributeStateEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    /**
     * 状态描述
     */
    private final String desc;
    /**
     * 状态code
     */
    private final Integer code;

    AttributeStateEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    @SuppressWarnings("unused")
    public static AttributeStateEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }
}
