package cn.com.duiba.cloud.zhongyan.goods.center.api.constant;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;

/**
 * 商品来源
 * 计算得出
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/29 19:03
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum GoodsSourceEnum implements IEnum<Integer> {
    OWN(1, "自有商品"),
    /**
     * 兑吧也是供应商一员
     */
    SUPPLIER(2, "供应商商品"),
    ;


    private final Integer code;
    private final String desc;

    GoodsSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取code
     *
     * @return value()
     */
    @Override
    public Integer getDbCode() {
        return getCode();
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
