package cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods;

import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.MediaTypeEnum;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.zhongyan.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * spu\sku共有的属性
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:52 上午
 */
@Setter
@Getter
public abstract class AbstractGoodsDto extends BaseDto implements GeneralBiz {
    private static final long serialVersionUID = 1L;

    /**
     * 属性
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private List<GoodsAttributeDto> attributeList;

    /**
     * 图片
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_TENANT)
    private List<GoodsImageDto> imageList;

    /**
     * 图文详情
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_TENANT)
    private GoodsDetailDto detail;


    /**
     * 库存渠道Id
     * 要么是skuChannelId，要么是spuChannelId
     */
    private Long channelId;

    /**
     * 按照类型获取图片
     *
     * @param mediaTypeEnum
     *
     * @return
     */
    public List<String> getImageByImageType(MediaTypeEnum mediaTypeEnum) {
        return Optional.ofNullable(getImageList()).orElse(new ArrayList<>())
                .stream()
                .filter(goodsImageDto -> Objects.equals(goodsImageDto.getImgType(), mediaTypeEnum.getMediaType()))
                .map(GoodsImageDto::getPicUrl)
                .collect(Collectors.toList());
    }
}
