package cn.com.duiba.cloud.zhongyan.goods.center.api.dto.goods;

import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.AttributeTypeEnum;
import cn.com.duiba.cloud.zhongyan.goods.center.api.constant.GeneralTypeEnum;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.BaseDto;
import cn.com.duiba.cloud.zhongyan.goods.center.api.dto.GeneralBiz;
import cn.com.duiba.cloud.zhongyan.goods.center.api.util.GoodsSnapshotUtil;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/11/15 10:50 上午
 */
@Setter
@Getter
public class GoodsAttributeDto extends BaseDto implements Serializable, GeneralBiz {
    private static final long serialVersionUID = 1L;

    /**
     * 属性id
     */
    private Long attrId;
    /**
     * 属性名
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String attrName;
    /**
     * 属性值
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private String attrValue;
    /**
     * 属性类型(1:参数属性,2:sku属性)
     *
     * @see AttributeTypeEnum
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Integer attrType;
    /**
     * 排序
     */
    @JSONField(label = GoodsSnapshotUtil.LABEL_SUPPLIER)
    private Long sort;

    /**
     * spuID或skuID
     */
    private Long generalId;
    /**
     * 类型(1:spu;2:sku)
     *
     * @see GeneralTypeEnum
     */
    private Integer generalType;
}
