package cn.com.duiba.cloud.zhongyan.goods.center.api.param.attribute;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class AttributeQueryParam extends PageRequest {

    private static final long serialVersionUID = 8299410433582885243L;

    /**
     * 属性ID
     */
    private Long attributeId;

    /**
     * 属性名称
     */
    private String attributeName;

    /**
     * 属性类型 {@link cn.com.duiba.cloud.zhongyan.goods.center.api.constant.AttributeTypeEnum}
     */
    private Integer attrType;
}
